/*
 * Decompiled with CFR 0.152.
 */
package morph.avaritia.handler;

import java.util.LinkedHashSet;
import java.util.Set;
import net.covers1624.quack.util.CrashLock;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class BlockBreakEvents {
    private static final CrashLock LOCK = new CrashLock("Already Initialized.");
    private static Set<ItemStack> capturedDrops = new LinkedHashSet<ItemStack>();
    private static boolean doItemCapture = false;

    public static void init() {
        LOCK.lock();
        MinecraftForge.EVENT_BUS.addListener(BlockBreakEvents::entityJoinWorld);
    }

    public static void entityJoinWorld(EntityJoinWorldEvent event) {
        if (doItemCapture && !event.isCanceled() && event.getEntity() instanceof ItemEntity) {
            ItemStack stack = ((ItemEntity)event.getEntity()).m_32055_();
            capturedDrops.add(stack);
            event.setCanceled(true);
        }
    }

    public static void enableItemCapture() {
        doItemCapture = true;
    }

    public static void stopItemCapture() {
        doItemCapture = false;
    }

    public static boolean isItemCaptureEnabled() {
        return doItemCapture;
    }

    public static Set<ItemStack> getCapturedDrops() {
        LinkedHashSet<ItemStack> dropsCopy = new LinkedHashSet<ItemStack>(capturedDrops);
        capturedDrops.clear();
        return dropsCopy;
    }
}

